#include <iostream>
#include <string.h>

#include "vegas.h"

#define pavegas pavegas_
#define MINDIM 1
#define MAXDIM 20
#ifndef STATESIZE
#define STATESIZE
#endif
 
extern char vegasstate_[]; // for saving of the last iteration

typedef const void (*Integrand)(int *, double *, int *, double *);

extern "C" void pavegas(int* ndim_, int* ncomp_, 
			void (*integrand)(int*, double*, int*, double*),
			double* pepsrel, double* pepsabs, int* deadtime_, 
			int* pntherm, int* pnref,
			int* pnstart, int* pnincrease, 
			int* pneval, int* pfail,
			double *integral, double *error, double *prob)
{
  
  if( *vegasstate_) {
    char *p;
    vegasstate_[STATESIZE -1] = 0;
    if( (p = strchr(vegasstate_, ' '))  ) *p = 0;
  }





  int ndim=*ndim_;
  int ncomp=*ncomp_;
  int nstart=*pnstart;
  int nincrease=*pnincrease;
  int deadtime=*deadtime_;

  //  std::cout<<" *** "<<ncomp<<"  "<<FNMX<<std::endl;

  int ntherm=*pntherm;
  int nref=*pnref;

  double epsrel=*pepsrel;
  double epsabs=*pepsabs;

  int ret_status = 0;

  if( ndim < MINDIM || ndim > MAXDIM ) *pfail = -1;
  else if(ncomp< 1 ||ncomp > FNMX) *pfail = -1;
  
  else {
    // setting up the boundaries ...
    double reg[2*ndim];
    int i;
    for (i=0; i < ndim; ++i)
      {
	// integration over hypercube ...
	reg[i]=0.0;
	reg[i+ndim]=1.0;
      }


    void (*integrand_)(int*, double*, int*, double*) = integrand;
    
    //---------------- START THE VEGAS INTEGRATION --------------------    
    /* 1. thermalization: ret_status can only be 
          0 : go to next init step
	  1 : leave the program
	  3 : go to next init step
	  4 : leave the program                                  
    */

    ret_status = vegas(reg, ndim,
		       integrand_,
		       0, nstart, ntherm,
		       NPRN_INPUT|NPRN_RESULT,
		       //NPRN_ALL,
		       1, 0, 15,
		       integral, error, prob, 
		       epsrel, epsabs, nincrease, deadtime);

    if(ret_status==1 || ret_status==4) {
      (*pfail)=ret_status;
      return;  }

    /* 2. refining the grid: ret_status can be
          0 : go to next init step
	  1 : leave the program
	  3 : go to next init step      
    */
    
    ret_status = vegas(reg, ndim,
		       integrand_,
		       1, nstart, nref,
		       //NPRN_ALL,
		       NPRN_INPUT | NPRN_RESULT,
		       ncomp, 0, 15,
		       integral, error, prob, 
		       epsrel, epsabs, nincrease, deadtime);

    if(ret_status==1) {
      (*pfail)=ret_status;
      return; }

    /* 3. inheriting the result: ret_status can be
          1 : leave the program
	  2 : leave the program
	  3 : leave the program  d;) 
    */



    ret_status = vegas(reg, ndim,
		       integrand_, 
		       2, nstart, 1000000, 
		       //NPRN_ALL,
		       NPRN_INPUT | NPRN_RESULT,
		       ncomp, 0, 15,
		       integral, error, prob, 
		       epsrel, epsabs, nincrease,deadtime);
    (*pfail)=ret_status;
  }
  
  return;
}
