
      subroutine mypdf(xi1,q,pdfset, isetval, upv,dnv,usea,dsea,str,
     &                 chm,bot,glu)
      implicit none
      character*60 pdfset
      double precision xi1,q,upv,dnv,usea,dsea,str,chm,bot,glu,sbar
      double precision cbar, bbar, phot
      integer mode,isetval
      INTEGER iset,ieigen,neigen,ix,nx,iq,nq
      PARAMETER(neigen=15)      ! number of eigenvectors

      CHARACTER prefix*50





      if (pdfset.eq.'MRSTLO') then
         mode =1       
         call mrstlo(xi1,q,mode,upv,dnv,usea,dsea,str,chm,bot,glu)  
      elseif (pdfset.eq.'MRST2001') then
         mode =1       
         call mrst2001(xi1,q,mode,upv,dnv,usea,dsea,str,chm,bot,glu)
      elseif (pdfset.eq.'MRSTNNLO') then
         mode=1
         call mrstnnlo(xi1,q,mode,upv,dnv,usea,dsea,str,chm,bot,glu)
      elseif (pdfset.eq.'MRST2004NLO') then
         mode=1         
         call mrst2004(xi1,q,mode,upv,dnv,usea,dsea,str,chm,bot,glu)
      elseif (pdfset.eq.'MRST2004NNLO') then
         mode=2
         call mrst2004(xi1,q,mode,upv,dnv,usea,dsea,str,chm,bot,glu)

      elseif (pdfset.eq.'MRST2006NNLO') then 
      prefix = "Grids/mrst2006nnlo" ! prefix for the grid files
C--   N.B. This fit has m_c = 1.43 GeV, m_b = 4.30 GeV,
C--   and Lambda_{QCD} = 0.2808 GeV => alpha_S(M_Z) = 0.1191.
C--   There are three different interfaces to access the PDFs.
C--   Consider only the central PDF set to start with.
      iset = isetval
C--   First the traditional MRST-like interface (but note the "sbar").

         call GetAllPDFs(prefix,iset,xi1,q,
     &     upv,dnv,usea,dsea,str,sbar,chm,bot,glu)


      elseif (pdfset.eq.'MSTW2008LO') then 
      prefix = "Grids/mstw2008lo" ! prefix for the grid files

      
      iset = isetval

      if (iset.gt.0) then 
         prefix = prefix(1:len_trim(prefix))//'.90cl'
      endif


      CALL GetAllPDFs08(prefix,iset,xi1,q,
     &        upv,dnv,usea,dsea,str,sbar,
     &        chm,cbar,bot,bbar,glu,phot)

      elseif (pdfset.eq.'MSTW2008NLO') then 
      prefix = "Grids/mstw2008nlo" ! prefix for the grid files
      iset = isetval
      if (iset.gt.0) then 
         prefix = prefix(1:len_trim(prefix))//'.90cl'
      endif

      CALL GetAllPDFs08(prefix,iset,xi1,q,
     &        upv,dnv,usea,dsea,str,sbar,
     &        chm,cbar,bot,bbar,glu,phot)

      elseif (pdfset.eq.'MSTW2008NNLO') then 
      prefix = "Grids/mstw2008nnlo" ! prefix for the grid files
      iset = isetval
      if (iset.gt.0) then 
         prefix = prefix(1:len_trim(prefix))//'.90cl'
      endif

      CALL GetAllPDFs08(prefix,iset,xi1,q,
     &        upv,dnv,usea,dsea,str,sbar,
     &        chm,cbar,bot,bbar,glu,phot)



      endif

      END

C--- RETURN(Sum( fi(x1)*fj(x2)*x1*x2)) 
      subroutine lumif(collider,x1,x2,muf,pdfset, isetval, Lgg,Lqgt,
     &     Lqqbt,Lqq,Lq1q2)
      implicit none
      integer isetval
      double precision x1,x2,muf
      double precision Lgg,Lqg,Lgq, Lqbq, Lqqb,Lqq,Lq1q2
      character*60 pdfset,collider      
      double precision upv1,dnv1,usea1,dsea1,str1,chm1,bot1,glu1
      double precision upv2,dnv2,usea2,dsea2,str2,chm2,bot2,glu2
      double precision mu1, md1, ms1, mc1, mb1, mub1, mdb1, msb1 
      double precision mcb1, mbb1
      double precision mu2, md2, ms2, mc2, mb2, mub2, mdb2, msb2 
      double precision mcb2, mbb2, Lqgt, Lqqbt

      external mypdf


      if ((x1.gt.1d0).or.(x2.gt.1d0)) then 

      Lgg = 0d0
      Lqgt= 0d0
      Lqqbt = 0d0
      Lqq = 0d0
      Lq1q2 = 0d0

      else


      call mypdf(x1,muf,pdfset, isetval, upv1,dnv1,usea1,dsea1,str1,
     &           chm1,bot1,glu1)

      call mypdf(x2,muf,pdfset, isetval, upv2,dnv2,usea2,dsea2,str2,
     &           chm2,bot2,glu2)



      if (collider.eq.'LHC') then 
         mu1 = upv1 + usea1
         md1 = dnv1 + dsea1
         ms1 = str1
         mc1 = chm1 
         mb1 = bot1
         mub1 = usea1
         mdb1 = dsea1
         msb1 = str1
         mcb1 = chm1 
         mbb1 = bot1

         mu2 = upv2 + usea2
         md2 = dnv2 + dsea2
         ms2 = str2
         mc2 = chm2 
         mb2 = bot2
         mub2 = usea2
         mdb2 = dsea2
         msb2 = str2
         mcb2 = chm2 
         mbb2 = bot2

      elseif (collider.eq.'TEVATRON') then 
         mu1 = upv1 + usea1
         md1 = dnv1 + dsea1
         ms1 = str1
         mc1 = chm1 
         mb1 = bot1
         mub1 = usea1
         mdb1 = dsea1
         msb1 = str1
         mcb1 = chm1 
         mbb1 = bot1

         mu2 = usea2
         md2 = dsea2
         ms2 = str2
         mc2 = chm2 
         mb2 = bot2
         mub2 = upv2 + usea2
         mdb2 = dnv2 + dsea2
         msb2 = str2
         mcb2 = chm2 
         mbb2 = bot2

      endif

      Lgg = glu1*glu2

      Lgq = glu1*(mu2+md2+ms2+mc2+mb2+
     &            +mub2+mdb2+msb2+mcb2+mbb2)

      Lqg = glu2*(mu1+md1+ms1+mc1+mb1+
     &            +mub1+mdb1+msb1+mcb1+mbb1)

      Lqgt= Lqg+Lgq

      Lqqb = mu1*mub2+md1*mdb2+ms1*msb2+mc1*mcb2+
     &       mb1*mbb2

      Lqbq = mu2*mub1+md2*mdb1+ms2*msb1+mc2*mcb1+
     &       mb2*mbb1

      Lqqbt = Lqqb + Lqbq


      Lqq =  mu1*mu2+md1*md2+ms1*ms2+mc1*mc2+
     &       mb1*mb2+
     &       mub1*mub2+mdb1*mdb2+msb1*msb2+mcb1*mcb2+
     &       mbb1*mbb2


      Lq1q2 =  (mu1+mub1)*(md2+ms2+mc2+mb2+mdb2+msb2+mcb2+mbb2)
     &        +(md1+mdb1)*(mu2+ms2+mc2+mb2+mub2+msb2+mcb2+mbb2)
     &        +(mc1+mcb1)*(mu2+ms2+md2+mb2+mub2+msb2+mdb2+mbb2)
     &        +(ms1+msb1)*(mu2+md2+mc2+mb2+mub2+mdb2+mcb2+mbb2)
     &        +(mb1+mbb1)*(mu2+ms2+mc2+md2+mub2+msb2+mcb2+mdb2)
      

      endif

      END



