      subroutine INTE2(ndim,vars,ncomp,risc)
      implicit none
      INTEGER ndim,ncomp,jj,isetval, ival, Ngrids
      double precision vars(ndim), risc(ncomp)
      double precision risca(ncomp), riscb(ncomp), riscc(ncomp)
      
      double precision Rplus, Rdelta, Rreg
      double precision xorki

      integer iii

      common /Ngrids/ Ngrids

      if (ncomp.eq.1) then 
         call matrixelem(vars,2,1,risc)
      else
         call matrixelem(vars,2,(Ngrids+1),risca)
         call matrixelem(vars,1,(Ngrids+1),riscb)
         call matrixelem(vars,0,(Ngrids+1),riscc)

         ival = 0
         do iii=1,(Ngrids+1)
            ival = ival+1 
            risc(ival) =  risca(iii) 
         enddo
         do iii=1,(Ngrids+1)
            ival = ival+1 
            risc(ival) =  riscb(iii) 
         enddo
         do iii=1,(Ngrids+1)
            ival = ival+1 
            risc(ival) =  riscc(iii) 
         enddo
      endif
      end


      subroutine INTE1(ndim,vars,ncomp,risc)
      implicit none
      INTEGER ndim,ncomp,jj,isetval, ival, Ngrids
      double precision vars(ndim), risc(ncomp)
      double precision Rplus, Rdelta, Rreg
      double precision xorki
      double precision risca(ncomp), riscb(ncomp), riscc(ncomp)
      integer iii

      common /Ngrids/ Ngrids

      if (ncomp.eq.1) then 

         call matrixelem(vars,1,1,risc)

      else
         call matrixelem(vars,1,(Ngrids+1),riscb)
         call matrixelem(vars,0,(Ngrids+1),riscc)


         ival = 0
         do iii=1,(Ngrids+1)
            ival = ival+1 
            risc(ival) =  riscb(iii) 
         enddo
         do iii=1,(Ngrids+1)
            ival = ival+1 
            risc(ival) =  riscc(iii) 
         enddo
      endif


      end      


      subroutine INTE0(ndim,vars,ncomp,risc)
      implicit none
      INTEGER ndim,ncomp,jj,isetval, ival, Ngrids
      double precision vars(ndim), risc(ncomp)
      double precision Rplus, Rdelta, Rreg
      double precision xorki

      common /Ngrids/ Ngrids

      if (ncomp.eq.1) then 
         call matrixelem(vars,0,1,risc)

      else

         call matrixelem(vars,0,(Ngrids+1),risc)        
      endif
      end



      subroutine givevalerr(Nmax, ris, cval, pluse, minuse)
      implicit none 
      integer Nmax, jj, jplus, jminus
      double precision ris(1:(Nmax+1))
      double precision cval, pluse, minuse, esymm 
      double precision tmp, tmp1, tmp2

      cval=ris(1)
      pluse=0d0
      minuse=0d0

      esymm = 0d0
      do jj=1,Nmax/2
         jplus = 2*jj
         jminus = 2*jj+1

         tmp1 = ris(jplus) - cval
         tmp2 = ris(jminus) - cval
         if (tmp1.gt.tmp2) then 
            tmp = tmp1 
         else
            tmp = tmp2
         endif
         if (tmp.lt.0d0) then 
            tmp = 0d0
         endif
         pluse = pluse + tmp**2         

         tmp1 = - tmp1
         tmp2 = - tmp2
         if (tmp1.gt.tmp2) then 
            tmp = tmp1 
         else
            tmp = tmp2
         endif
         if (tmp.lt.0d0) then 
            tmp = 0d0
         endif

         minuse = minuse + tmp**2

         esymm = esymm + (tmp1-tmp2)**2

      enddo

      esymm = dsqrt(esymm)/cval*100d0/2d0

      pluse=dsqrt(pluse)/cval*100d0
      minuse=dsqrt(minuse)/cval*100d0

C----  for symmetric  error uncommend here
C      pluse = esymm
C      minuse = esymm

      end
