      double precision function deltaRadja(mW,mZ,GammaW,GammaZ,
&                      mtop,mhiggs)

      implicit none
      double complex x, z, zx
      double complex Hm1, Hmr, H0m1, Hmrmr,
     &               Hmrm1, H00m1, Hmrmrmr,
     &               Hmrmrm1, H0mrmr,Hm4mrm1, 
     &               Hmr0m1, xspenz, xli3, A1

      integer jj

      double precision  pi, alpha 
      double precision  mtop
      double precision  mhiggs, mW, mZ
      double precision  GammaW, GammaZ
      double precision  lambda, delta
      double complex    tH, wH, zH
      double complex    sw, cw, prefac
      double complex    ieps
      double complex    G1Lt, Glf2L


      ieps = dcmplx(0.d0,1.d-6)



      cw   = sqrt(mW*dcmplx(mW,-GammaW)/(mZ*dcmplx(mZ,-GammaZ)))
      sw   = sqrt(1d0-cw**2)
      
      alpha = 1/137.036d0
      pi   = 3.141592653589793238462643383279502884197d0

      prefac = 2d0/cw**4*(
     &         5d0/4d0-7d0/3d0*sw**2+22d0/9d0*sw**4)
      
      tH     = (mtop/mhiggs)**2
      wH     =  mW*dcmplx(mW,-GammaW)/(mhiggs**2)
      zH     =  mZ*dcmplx(mZ,-GammaZ)/(mhiggs**2)
      G1Lt   = -4d0*tH*(2d0-(1-4d0*tH)*Hmrmr(-1d0/tH - ieps))
      Glf2L  = prefac*A1(zH) + 4d0*A1(wH)
      lambda = dreal(alpha*wH/(2d0*pi*sw**2) * Glf2L/G1Lt)
      delta  = 2*lambda
      
      deltaRadja = delta
      end



      double complex function A1(x)
      implicit none
      double complex x, minvx
      double complex Hm1, Hmr, H0m1, Hmrmr,
     &               Hmrm1, H00m1, Hmrmrmr,
     &               Hmrmrm1, H0mrmr,Hm4mrm1, 
     &               Hmr0m1, xspenz, xli3

      double complex la

      minvx = - 1d0/x

      A1   = - 4d0 + 2d0*(1d0 - x)*Hm1(minvx)
     &       - 2d0*x*H0m1(minvx)
     &       + 2d0*(1d0-3d0*x)*H00m1(minvx)
     &       + 2d0*(1d0-2d0*x)*H0mrmr(minvx)
     &       - 3d0*(1d0-2d0*x)*Hmrmrm1(minvx)
     &       - sqrt(1d0-4d0*x)*( 2d0*Hmr(minvx)
     &       - 3d0*(1d0-2d0*x)*Hm4mrm1(minvx)
     &       + 2d0*(1d0-2d0*x)*Hmr0m1(minvx)
     &       + 2d0*(1d0-2d0*x)*Hmrmrmr(minvx) )

      
      end
