      double complex function bornampl(mtop, mhiggs)
      implicit none
      double precision mtop, mhiggs, tn, pi
      double precision Dratio, Delta, Dnum, Dden 
      double complex scanal, scfactor

      pi=3.1415926535897D0
      tn=4d0*mtop**2/mhiggs**2

      if (tn.gt.1d0) then 
         scanal =  dcmplx(dasin(1D0/dsqrt(tn)), 0d0)
      else

         Delta = 1d0- tn
         Delta = dsqrt(Delta)

         Dnum = 1d0 +  Delta
         Dden = 1d0 -  Delta

         Dratio = Dnum/Dden

         scanal = dcmplx(dlog(Dratio) ,-pi) 
         scanal = scanal*dcmplx(0d0,0.5d0)
      endif


      scfactor = dcmplx(1D0,0d0)+dcmplx(1-tn, 0d0)*scanal**2
      scfactor = 3D0/2D0*tn*scfactor

      bornampl = scfactor
      return
      end
